#ifndef const_h
#define const_h

/* Important: if the distance function is symmetric, define the following variable */
#define SYMMETRIC

#define NDEBUG
//#define debugout cout
//#define VERBOSE

#define _SCL_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#define _ATL_SECURE_NO_WARNINGS
#define _AFX_SECURE_NO_WARNINGS

#define MAX_STRING_LEN 300
#define null NULL
#define nil NULL

/* the maximal distance value*/
#define DIST_INFTY 99999999.9
#define INT_INFTY 99999999

/* the limit on the number of objects */
#define MAX_NUM_OBJ 80000

/* the limit on the number of reference objects */
#define MAX_NUM_REF 1100

// Possible method ID
#define BD_LOCAL_CENTER 29 // Based on LOCAL_CENTER, but use bd to select centers
				// for each tree.
#define REF_LOCAL_CENTER 30 // Based on BD_LOCAL_CENTER, but use the total distances
				// to the reference structures to define the best structures.
#define USER_LOCAL_CENTER 31 // Based on REF_LOCAL_CENTER, but let user specify
				// the list of best structures.


// Possible distance type
#define DIST_VOID -1 //distType not specified.
#define DIST_M 0 //m file.
#define DIST_NEW_M 6// use m file but through a different way.
#define DIST_CARMSD 11 // Ca RMSD distance

#define SZ_LINE 200

#endif


