#ifndef dataobj_h
#define dataobj_h

#include <string>

#include "const.h"
#include "global.h"
#include "mobj.h"
#include "rmsdobj.h"


class DataObj {
	void * obj;
public:
	DataObj() {
		obj = null;
	}
	DataObj(std::string data) {
		obj = null;
		readin(data);
	}

	DataObj(const DataObj & ob) {
	obj = null;
	if(ob.obj != null)
		*this = ob;
	}

	DataObj& operator=(const DataObj& ob) {
		if(ob.obj == null)
			obj = null;
		else {
			if(obj == null)
				obj = newObj();
			switch(gb.distType) {
			case DIST_NEW_M:
			case DIST_M:
				((MObj*)obj)->copyConstruct(*((MObj*)(ob.obj)));
				break;
			case DIST_CARMSD:
				((RmsdObj*)obj)->copyConstruct(*((RmsdObj*)(ob.obj)));
				break;
			default:
				printf("In function DataObj& operator=(const DataObj& ob) : Error! Wrong object type!\n");
				exit(1);
			}
		}
		return *this;
	}

	int operator==(const DataObj& ob) {
		bool equal;
		switch(gb.distType) {
		case DIST_NEW_M:
		case DIST_M: {
				MObj * thisP = (MObj*)obj;
				MObj * thatP = (MObj*)ob.obj;
				equal = ( *thisP == *thatP);
			}
			break;
		case DIST_CARMSD:{
				RmsdObj * thisP = (RmsdObj*)obj;
				RmsdObj * thatP = (RmsdObj*)ob.obj;
				equal = ( *thisP == *thatP);
			}
			break;
		default:
			printf("In function operator==(const DataObj& ob): Error! Wrong object type!\n");
			exit(1);
		}
		if(equal) return 1;
		else return 0;
	}

	~DataObj() {
		if(obj != null) {
			switch(gb.distType) {
			case DIST_VOID://obj == null, do nothing
				break;
			case DIST_NEW_M:
			case DIST_M:
				delete (MObj *)obj;
				break;
			case DIST_CARMSD:
				delete (RmsdObj *)obj;
				break;
			default:
				printf("In function ~DataObj(): Error! Wrong object type!\n");
				exit(1);
			}
		}
	}

	/* get the maximal distance between objects */
	float getMaxDist() {
		switch(gb.distType) {
//		case DIST_M:
//			return ((MObj *)obj)->getMaxDist();
//			break;
		default:
			printf("Error! 'getMaxDist' is not defined for this distance type!");
			exit(1);
		}
	}

	/* the size of this data object */
	int size() {
		int retVal;
		switch(gb.distType) {
//		case DIST_ALIGN:
//			retVal = ((AlignObj*)obj)->size();
//			break;
		default:
			printf("In function fromStr: Error! Wrong object type!\n");
			exit(1);
		}
		return retVal;
	}

	void print(ostream& os) const {
		switch(gb.distType) {
		case DIST_VOID://obj == null, do nothing
			break;
		case DIST_CARMSD:
			((RmsdObj *)obj)->print(os);
			break;
		default:
			printf("In function print(): Error! Wrong object type!\n");
			exit(1);
		}
	}

	void * newObj() {
		void * p;
		switch(gb.distType) {
		case DIST_NEW_M:
		case DIST_M:
			p = new MObj();
			break;
		case DIST_CARMSD:
			p= new RmsdObj();
			break;
		default:
			printf("In function readin(): Error! Wrong object type!\n");
			exit(1);
		}
		return p;
	}

	/* read in a data string and convert it into a DataObj
	 * @param data
	 */
	void readin(std::string & data) {
		switch(gb.distType) {
		case DIST_NEW_M:
		case DIST_M:
			obj = new MObj();
			((MObj *)obj)->readin(data);
			break;
		case DIST_CARMSD:
			obj = new RmsdObj();
			((RmsdObj *)obj)->readin(data);
			break;
		default:
			printf("In function readin(): Error! Wrong object type!\n");
			exit(1);
		}
	}

	float distance(DataObj & b) {
		float dist = DIST_INFTY;
		switch(gb.distType) {
		case DIST_NEW_M:
		case DIST_M:
			dist = ((MObj *)obj)->distance( *((MObj*) b.obj));
			break;
		case DIST_CARMSD:
			dist = ((RmsdObj *)obj)->distance( *((RmsdObj*) b.obj));
			break;
		default:
			printf("In function distance(): Error! Wrong object type!\n");
			exit(1);
		}
		return dist;
	}
};

#endif


