#include "global.h"
#include "distdb.h"

#ifdef VERBOSE
int Node::count = 0;
#endif

void DistDb::getRandListAndRemain(int objNum, deque <string> & inList, 
										 deque <string> & resList, 
										 deque <string> & remaining) {
	list <string> tempList;
	deque <string>::iterator it;
	for(it = inList.begin(); it != inList.end(); it ++) {
		string id = *it;
		tempList.push_back(id);
	}
	
	//select the random set
	float rate = ((float)objNum) / tempList.size(); assert(rate <= 1);
	list <string> ::iterator tIt = tempList.begin();
	while((int)resList.size() < objNum) {
		if(tIt == tempList.end()) tIt = tempList.begin();
		float val = fRnd(0,1);
		if(val < rate) {
			resList.push_back(*tIt);
			list <string> ::iterator toDelIt = tIt;
			tIt ++;
			//remaining.push_back(*toDelIt);
			tempList.erase(toDelIt);
		}else tIt ++;
	}

	for(tIt = tempList.begin(); tIt != tempList.end(); tIt ++)
		remaining.push_back(*tIt);
} 

void DistDb::getRandListFromList(int objNum, const deque <string> & inList,
						 deque <string> & resList) {
	list <string> tempList;
	deque <string>::const_iterator it;
	for(it = inList.begin(); it != inList.end(); it ++) {
		string id = *it;
		////set <string> ::iterator sIt = excSet.find(id);
		////if(sIt == excSet.end()) {
		////	tempList.push_back(id);
		////}
		tempList.push_back(id);
	}
	
	//select the random set
	float rate = ((float)objNum) / tempList.size(); assert(rate <= 1);
	list <string> ::iterator tIt = tempList.begin();
	while((int)resList.size() < objNum) {
		if(tIt == tempList.end()) tIt = tempList.begin();
		float val = fRnd(0,1);
		if(val < rate) {
			resList.push_back(*tIt);
			list <string> ::iterator toDelIt = tIt;
			tIt ++;
			tempList.erase(toDelIt);
		}else tIt ++;
	}
} 

void DistDb::getRandList(int objNum, deque <string> & inList, deque <string> & resList) {
    //build a temp list
	list <string> tempList;
	deque <string>::iterator it;
	for(it = inList.begin(); it != inList.end(); it ++) {
		string id = *it;
		tempList.push_back(id);
	}

	//select the random set
	float rate = ((float)objNum) / tempList.size(); assert(rate <= 1);
	list <string> ::iterator tIt = tempList.begin();
	while((int)resList.size() < objNum) {
		if(tIt == tempList.end()) tIt = tempList.begin();
		float val = fRnd(0,1);
		if(val < rate) {
			resList.push_back(*tIt);
			list <string> ::iterator toDelIt = tIt;
			tIt ++;
			tempList.erase(toDelIt);
		}else tIt ++;
	}
}

void DistDb::getRandList(int objNum, deque <string> & excludeList, 
						 deque <string> & inList, deque <string> & resList) {
    //build an exclusion set
    set <string> excSet;
    deque <string> :: const_iterator eIt;
    for(eIt = excludeList.begin(); eIt != excludeList.end(); eIt ++) {
        string id = *eIt;
        excSet.insert(id);
    }
	list <string> tempList;
	deque <string>::iterator it;
	for(it = inList.begin(); it != inList.end(); it ++) {
		string id = *it;
		set <string> ::iterator sIt = excSet.find(id);
		if(sIt == excSet.end()) {
		tempList.push_back(id);
		}
	}
	
		//select the random set
	float rate = ((float)objNum) / tempList.size(); assert(rate <= 1);
	list <string> ::iterator tIt = tempList.begin();
	while((int)resList.size() < objNum) {
		if(tIt == tempList.end()) tIt = tempList.begin();
		float val = fRnd(0,1);
		if(val < rate) {
		resList.push_back(*tIt);
		list <string> ::iterator toDelIt = tIt;
		tIt ++;
		tempList.erase(toDelIt);
		}else tIt ++;
	}
}   


