#include <iostream>
using namespace std;

#define _SCL_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS

#include <math.h>
#include <unistd.h>

#include "global.h"


Global gb;

float fRnd(float min, float max)
{
	return ((float)rand()/(float)RAND_MAX)*(max-min) + min;
}

/* return a random integer number in [min, max] */
int rnd(int min, int max)
{
	return (rand()%(max-min+1) + min);
}

/* remove the file path in str and return the id */
std::string extractId(const std::string & str) {
	std::vector<std::string> temp;
	//boost::split(temp, str, boost::is_any_of("/"), boost::token_compress_on);		
	Pattern::split(temp, str, "/");
	int len = temp.size();
	return temp[len - 1];
}

int
/*============================================================================
|
| Desc:    Reads one line of data from file
|
| In:      fp        Handle to open file
| Out:     line      Buffer containing the line read
|
| Returns: EOF if read to the end of file
|
============================================================================*/
readLine(FILE *fp, char line[])
{
   int i, c;

   i = 0;
   c = fgetc( fp );
   while ( (i<SZ_LINE) && (c!= '\n') && (c!=EOF) ) {
	  line[i] = c;
	  c = fgetc( fp );
	  i++;
   }
   //line[i] = '\n';
   //i++;
   line[i] = '\0';
   return ( c==EOF ? EOF : 0 );
}

/* Calculate and output the class statistics in table.
 * table: the input table.
 * os: the output.
 */
void getClassStat(map <string, string> & table, ostream & os) {
	map <string, int> labelStat;
	map <string, string> ::iterator it;
	for (it = table.begin(); it != table.end(); it ++) {
		string label = it->second;

		// Collect label statistics.
		map <string, int> ::iterator mIt = labelStat.find(label);
		if (mIt == labelStat.end()) {
			labelStat[label] = 1;
		}else labelStat[label] ++;
	}
	// Output label statistics.
	double size = (double) table.size();
	map <string, int> ::iterator mIt;
	for (mIt = labelStat.begin(); mIt != labelStat.end(); mIt ++) {
		os << mIt->first << ": " << mIt->second;
		double rate = mIt->second / size;
		double prob = exp( 50*log(1-rate) ); // the probability of not being sampled by 100 samples.
		os << " " << 100 * rate << " % prob: " << prob << endl;
	}
}

/* 
 * Parse input parameters
 */
void Global::parseParameter(int argc, char* argv[]) {
	cout << "Parsing parameters.. " << endl;
	char c;//int c;
	if ( argc > 1 ) {
		while ((c = getopt(argc, argv, 
			"B:M:R:S:a:b:d:f:h:i:l:m:n:o:p:q:r:s:t:y:")) != -1)
		{
			cout<<" -"<<c<<" "<<optarg;
			switch (c) {
				case 'B':
					bestFile = new char[MAX_STRING_LEN];
					strcpy(bestFile, optarg);
					//readList(bestFile, bestList);
					break;
				case 'M':
					mFile = new char[MAX_STRING_LEN];
					strcpy(mFile, optarg);
					break;
				case 'R':
					refFile = new char[MAX_STRING_LEN];
					strcpy(refFile, optarg);
					break;
				case 'S':
					sampleSize = atoi(optarg);
					break;
				case 'a':
					assisFile = new char[MAX_STRING_LEN];
					strcpy(assisFile, optarg);
					readLabel(assisFile, assisTab, enerTab);
					//readClass(assisFile, assisTab);
					//getClassStat(assisTab, cout);
				case 'b':
//					binNum = atoi(optarg);
//					break;
				case 'd':
					denThres = atoi(optarg);
					break;
				case 'f':
					//filterMethod = atoi(optarg);
					break;
				case 'h':
					hashSize = atoi(optarg);
					break;
	 			case 'i':
					dataFile = new char[MAX_STRING_LEN];
					strcpy(dataFile, optarg);
					break;
	 			case 'l':
	 				leafThres = atoi(optarg);
	 				break;
				case 'm':
					methodId = atoi(optarg);
					break;
				case 'n':
//					objNum = atoi(optarg);
//					break;
				case 'o':
					outFile = new char[MAX_STRING_LEN];
					strcpy(outFile, optarg);
					break;
				case 'p':
					splitFactor = atoi(optarg);
					setBinLabels();
					break;
				case 'q':
					queryFile = new char[MAX_STRING_LEN];
					strcpy(queryFile, optarg);
					break;
				case 'r':
					fixedPivotNum = atoi(optarg);
					break;
				case 's':
					seed = atoi(optarg);
					break;
				case 't':
					treeNum = atoi(optarg);
					break;
				case 'y':
					distType = atoi(optarg);
					break;
				default:  
  					printf("Wrong parameter type!\n");
					exit(1);
				break;
			}
		}
	}else {
		printf("Usage: hsforest [OPTION]\n");
		printf("Options:\n");
		printf("\t<-i> A file listing the absolute path to each decoy.\n");
		printf("\t<-R> A file listing the absolute path to each pivot decoy. Should be selected randomly.\n");
		printf("\t<-B> A file listing the absolute path to the 10 best energy decoy. The file can contain between 1 and 10 decoys.\n");
		//printf("\t<-n> # of data objects\n");
		printf("\t<-o> Output file for top decoys (sorted).\n");
		printf("\t<-r> Number of pivots to sample from pivots in pivot file. Recommend value: between 20 and 60.\n");
		printf("\t<-h> H_max value. Recommended value: half of the value of the <-r> parameter.\n");
		printf("\t<-t> Number of trees. Recommended value: between 15 and 30. \n");
		printf("\t[-S] (Optional) Number of largest clusters to consider. Default value: 30.");
		printf("\n\n");
		exit(0);
	}

	//cout << endl << "seed " << seed << endl;
	if(seed == -1) {//create a new seed using the current time
		srand((unsigned)time(NULL));
	}else srand(seed);

	cout << endl << " done." << endl;
}



