#ifndef global_h
#define global_h

#define _SCL_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#define _ATL_SECURE_NO_WARNINGS
#define _AFX_SECURE_NO_WARNINGS

#include <deque>
#include <fstream>
#include <iostream>
#include <map>
#include <ostream>
#include <string>
#include <vector>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "const.h"
//#include "getopt.h"
//#include "debug.h"
//#include "dist.h"

#define absVal(a) ((a)<0?(-a):(a)) 

using namespace std;

typedef pair <string, float> strFloatPair;

struct SortProcess : public std::binary_function<strFloatPair &, strFloatPair &, bool>
{
	bool operator()(strFloatPair & a, strFloatPair & b) const {                             
	//return true if left is logically less then right for given comparison
		if(a.second < b.second)
			return true;
		else return false;
	}
};

typedef pair <string, string> strStrPair;

struct StrSortProcess : public std::binary_function<strStrPair &, strStrPair &, bool>
{
	bool operator()(strStrPair & a, strStrPair & b) const {
		if(a.second < b.second)
			return true;
		else return false;
	}
};

typedef pair <string, int> strIntPair;

struct IntSortProcess : public std::binary_function<strIntPair &, strIntPair &, bool>
{
	bool operator()(strIntPair & a, strIntPair & b) const {
		if(a.second < b.second) return true;
		else return false;
	}
};

class Pattern {
public:
	/* split a string based on patterns
	 * result: a vector of string to put the result
	 * s: the string
	 * pattern: a string of patterns
	 */
	static void split(std::vector <std::string> & result,
		const std::string & s, const std::string & pattern)
	{
		const char * cStr = s.c_str();
		char * tempStr = new char[s.length() + 1];
		strcpy( tempStr, cStr );
		const char * seps = pattern.c_str();
		char * token;
		// Establish string and get the first token:
		token = strtok( tempStr, seps ); // C4996
		while( token != NULL )
		{
			std::string elm( token );
			result.push_back( elm );

			// Get next token:
			token = strtok( NULL, seps ); // C4996
		}
		delete [] tempStr;
	}

	static std::string trim(const std::string & s) {
		std::string res = s;
		std::vector <std::string> temp;
		split(temp, s, " \t\n");
		std::vector <std::string> ::iterator it;
		for(it = temp.begin(); it != temp.end(); it ++) {
			if(it->length() > 0) res = *it;
		}
		return res;
	}
};

/* 
 * Global parameters of the whole program.
 */
class Global {
public:
	/* the input data file */
	char * dataFile;

//	/* total object number in the dataFile */
//	int objNum;

	/* distance type */
	int distType;

	/* which method */
	int methodId;

	/* number of fixed pivots */
	int fixedPivotNum;

	/* ref list file */
	char * refFile;

	/* for distance type DIST_M, this file contains pairwise distances 
	*/
	char * mFile;

	/* To assist different distance type */
	char * assisFile;

	/* file for output, such as individual query statistics. */
	char * outFile;

	/* if 1, this program is in debug mode */
	int debugFlag;

	/* maximal DataObj size */
	int maxDataObjSize;

	/* the size of sample */
	int sampleSize;

//	/* the number of bins for histogram output. */
//	int binNum;

	/* Density threshold. How many objects in a node to be consider
	 * significant.
	 */
	int denThres;

	/* number of trees in the HS-Forest */
	int treeNum;

	/* hash size. The number of hash tables in each set. */
	int hashSize;

	/* A table to map each ID to its class */
	map <string, string> assisTab;

	/* A table to map each ID to its energy */
	map <string, string> enerTab;

	/* The file that contains query objects in a column */
	char * queryFile;

	/* The factor to split the objects in hashing. (>= 2, <= 16)*/
	int splitFactor;

	/* The hex labels for hashing. from "0" to "F" */
	string binLabels[16];

	/* All characters in binLabels */
	string volcab;

//	/* sample rate for SAM_CENTER methods */
//	float samRate;

	/* leaf threshold. The number of objects in a node must be greater than this
	 * to be consider an internal node.
	 */
	size_t leafThres;

	/* map each object to a bit string */
	map <string, string> refHash;

//	/* node size limit. */
//	size_t szLimit;

	/* mapping each object to a total distance to all references */
	map <string, double> ob2rd;

	/* object with lowest total distances to all references */
	string minRefOb;

	/* best decoys */
	vector <string> bestList;

	/* the list of best objects in one column in the file */
	char * bestFile;

	/* random seed */
	int seed;

	Global() {// set default parameters
		dataFile = null;
		//objNum = -1;
		distType = DIST_CARMSD;
		methodId = USER_LOCAL_CENTER;

		//centerFile = null;
		refFile = null;
		mFile = null;
		outFile = null;
		queryFile = null;

		debugFlag = 0;
		//str2hexFlag = 1;
		maxDataObjSize = 0;

		assisFile = null;

		sampleSize = 30;

		//binNum = 10;

		denThres = 1;

		treeNum = 30;

		fixedPivotNum = 40;
		hashSize = 20;

		splitFactor = 2;
		volcab = "0123456789abcdef";

		leafThres = 1;

//		samRate = 0;

//		szLimit = 300;

		bestFile = null;

		seed = -1; //create a new seed using the current time
	}

	inline map <string, string> & getRefHash() {
		return refHash;
	}

	inline char getBit(int index) {
		return volcab.at(index);
	}

	/* set the binLabels according to splitFactor.
	 */
	inline void setBinLabels() {
		for (int i = 0; i < splitFactor; i ++) {
			binLabels[i] = volcab.substr(i,1);
		}
	}

	/* From hex to integer */
	inline int hex2int(char hex) {
		for (int i = 0; i < 16; i ++) {
			if (hex == volcab[i]) return i;
		}
		cout << "Error! A hex value runs out of range. Input: " << hex << endl;
		exit(1);
	}

	void parseParameter(int argc, char* argv[]);

	/* read a mapping from a file.
	 * inFile: each line is a string. The 1st column is the ID, and the 2nd column is its class. If there is
	 * the 3rd column, read it as the energy.
	 * table: map ID to its class.
	 */
	void readLabel(char * inFile, map <string, string> & table, map <string, string> & enerTable) {
	    ifstream is(inFile);
		if( ! is ) {
			cerr << "Error opening input stream "
				<< inFile << endl;
			//return;
			exit(1);
		}

	    std::string sLine;
		while(getline(is, sLine)) {
	        if(sLine.length() > 0) {
	            //resList.push_back(sLine);
	        	vector <string> result;
	        	Pattern::split(result, sLine, " \t");
	        	table[result[0]] = result[1];
	        	if (result.size() >= 3) enerTable[result[0]] = result[2];
	        }
	    }
	    is.close();
	}

	/* read a mapping from a file.
	 * inFile: each line is a string. The 1st column is the ID, and the 2nd column is its class.
	 * table: map ID to its class.
	 */
	void readClass(char * inFile, map <string, string> & table) {
	    ifstream is(inFile);
		if( ! is ) {
			cerr << "Error opening input stream "
				<< inFile << endl;
			//return;
			exit(1);
		}

	    std::string sLine;
		while(getline(is, sLine)) {
	        if(sLine.length() > 0) {
	            //resList.push_back(sLine);
	        	vector <string> result;
	        	Pattern::split(result, sLine, " \t");
	        	table[result[0]] = result[1];
	        }
	    }
	    is.close();
	}

	/* Get the energy from enerTab */
	string getEnergy(string id) {
		map <string, string> ::iterator it = enerTab.find(id);
		if(it == enerTab.end()) return "N/A";
		else return it->second;
	}

	/* Given an energy value, return the id of it
	 */
	 string queryEnergy(string & val) {
		 map <string, string> ::iterator it;
		 for (it = enerTab.begin(); it != enerTab.end(); it ++) {
			 if (it->second == val) return it->first;
		 }
		 return "";
	 }

	/* Get the class label from assisTab */
	string getClass(string id) {
		map <string, string> ::iterator it = assisTab.find(id);
		if(it == assisTab.end()) return "N/A";
		else return it->second;
	}

	map <string, string> & getAssisTab() {
		return assisTab;
	}

	/* read a list of string from a file
	 * inFile: each line is a string
	 */
	static void readList(char * inFile, deque <string> & resList) {
	    ifstream is(inFile);
		if( ! is ) {
			cerr << "Error opening input stream "
				<< inFile << endl;
			//return;
			exit(1);
		}

	    std::string sLine;
		while(getline(is, sLine)) {
	        if(sLine.length() > 0) {
	            resList.push_back(sLine);
	        }
	    }
	    is.close();
	}
};

extern int rnd(int min, int max);

extern int readLine(FILE *fp, char line[]);

extern void getClassStat(map <string, string> & table, ostream & os);

extern std::string extractId(const std::string & str);

extern float fRnd(float min, float max);

extern int rnd(int min, int max);

class Satree;

class DistDb;

class CandidateArr;

extern Global gb;

extern CandidateArr canArr;

#endif



