//============================================================================
// Name        : hsforest
// Author      : Jianjun Zhou
// Version     : 1.0
// Copyright   : This program is provided without any warranty. Use at your own risk.
// Description : Cluster decoys using HS-Forest
//============================================================================


#include <deque>
#include <fstream>
#include <iostream>
#include <list>
#include <set>
#include <string>


#include "const.h"
#include "global.h"
#include "getopt.h"
#include "distdb.h"

using namespace std;

/**
 *
 * @param argc
 * @param argv[]
 * @return
 */
int main(int argc, char* argv[]) {
	//cout << "Note: The object ID can not contain the '-' character." << endl;

    gb.parseParameter(argc, argv);

	DistDb distDb;
	distDb.readData(gb.dataFile);

	if(gb.distType == DIST_M) {
		MObj::readMFile(gb.mFile);
	}

	// Read in the list of candidate pivots and randomly sample a given nunber of them as pivots.
	deque <string> centerList;
	if(gb.refFile != null) {
		Global::readList(gb.refFile, centerList);
		distDb.str2hexStrBatch(centerList);
		distDb.getRandListFromList(gb.fixedPivotNum, centerList, distDb.getRefList());
	}else {
		cout << "No candidate pivots provided!" << endl;
		exit(1);
	}

	//preprocessing
	if (gb.distType != DIST_M && gb.mFile != null) {
		distDb.getDist().useMFile(gb.mFile);
	}

	deque <string> samObjects;// the list of sampled objects.
	switch (gb.methodId) {
	case USER_LOCAL_CENTER:
	case REF_LOCAL_CENTER:
	case BD_LOCAL_CENTER:
		distDb.forestDiag(gb, samObjects);
		break;
	default:
		cout << "Wrong method ID!" << endl;
		exit(1);
	}

	cout << endl << endl;
	cout << "Final result, num of objects returned: " << samObjects.size() << endl;
	distDb.outDenseObjects(samObjects, gb.outFile);
	cout << endl;

    return 0;
}

