#include <iostream>
#include <fstream>
#include <map>
#include <string>
#include <vector>

#include "const.h"
//#include "debug.h"
#include "global.h"
#include "mobj.h"
#include "dist.h"

using namespace std;

//map <string, float> MObj::distMap;
map <string, int> MObj::str2int;
map <string, int> MObj::str2ref;
float * MObj::arr[MAX_NUM_OBJ];


int MObj::getAddId(string & a, map <string, int> & idTab) {
	map <string, int> ::iterator it = idTab.find(a);
	if(it == idTab.end()) {//new id
		int curSize = idTab.size();
		idTab[a] = curSize;
		//arr[curSize] = new float[MAX_NUM_REF];
		return curSize;
	} else return it->second;
}

const void MObj::readin(const std::string & data) {
	//id = data;
	id = extractId(data);//remove the path from id
}

float MObj::get(const string & a, const string & b) {
	int idA = getId(a, str2int);
	int idB = getId(b, str2ref);
	if (arr[idA] == nil) {
		printf("Error! Distance not in database!");
		exit(1);
	}
	return arr[idA][idB];
}

/* deposit a distance */
void MObj::deposit(string & a, string & b, float val) {
	int idA = getAddId(a, str2int);
	int idB = getAddId(b, str2ref);

	if (arr[idA] == nil) {
		arr[idA] = new float[MAX_NUM_REF];
	}
	arr[idA][idB] = val;
}

/* read in an m file */
void MObj::readMFile(char inFile[]) {
    ifstream is(inFile);
	if(is.bad()) {
		cout << "Error openning " << inFile << endl;
		exit(1);
	}
    std::string sLine;
    while( ! is.eof()){
        getline(is, sLine);
        if(sLine.length() > 0) {
			std::vector<std::string> temp;
			//boost::split(temp, sLine, boost::is_any_of(" "), boost::token_compress_on);
			Pattern::split(temp, sLine, " ");
			//vector<string> temp = split(sLine);
			float val = atof(temp[2].c_str());
			deposit(temp[0], temp[1], val);

#ifdef SYMMETRIC
			deposit(temp[1], temp[0], val);
#endif
        }
    }
    is.close();	
}
