#ifndef mobj_h
#define mobj_h

#include <string>
#include <map>

#include "const.h"
//#include "debug.h"
//#include "global.h"

class MObj {
	//using namespace std;

	//static std::map <std::string, float> distMap;
	static map <string, int> str2int;// For the source object.
	static map <string, int> str2ref;// For the target object.
	static float * arr[MAX_NUM_OBJ];
	std::string id;
public:
	MObj() {
		for (int i = 0; i < MAX_NUM_OBJ; i ++) {
			arr[i] = nil;
		}
	}
//	~MObj() {
//debugout << "Deleting MObj.." << endl;
//		for (int i = 0; i < MAX_NUM_OBJ; i ++) {
//			if(arr[i] != nil) delete [] arr[i];
//		}
//	}

	int operator==(const MObj& obj) {
		if(id == obj.id) return 1;
		else return 0;
	}

	void copyConstruct(const MObj & obj) {
		//seq = obj.seq;
		id = obj.id;
	}

	/* get or add the id to a corresponding table
	 * idTab: the table mapping id to an integer. Could be str2int for
	 * the source object, or str2ref for the target object.
	 */
	static int getAddId(string & a, map <string, int> & idTab);

	/* Return an int id. If the string id is not in the database yet, print and error message and exit the program */
	static int getId(const string & a, map <string, int> & idTab) {
		map<string, int> ::const_iterator it = idTab.find(a);
		if(it == idTab.end()) {//new id
			printf("Error! ID not existed. ID:%s", a.c_str());
			exit(1);
		} else return it->second;
	}

    /* read in a data string and convert it into a DataObj
     * data: an ID
     */
	const void readin(const std::string & data);
    
	float distance(const MObj & b) const {
		return get(id, b.id);
	}

	/* get a distance. Alway using "a-b" as the id to perform the query (a <= b)*/
	static float get(const std::string & a, const std::string & b);

	/* deposit a distance */
	static void deposit(std::string & a, std::string & b, float val);

	/* read in an m file */
	static void readMFile(char inFile[]);
};

#endif

