/*
 * rmsdobj.h
 *
 *  Created on: May 30, 2011
 *      Author: jianjun
 */

#ifndef RMSDOBJ_H_
#define RMSDOBJ_H_

#include "math.h"

#include "SimpPDB.h"
#include "rmsd.h"

class CaRmsd {
	int _mLen;
	float* _previous;
	double** _mPOS1;
	double** _mPOS2;
public:
	CaRmsd() {
		_mLen       = 0;
		_previous 	= NULL;
		_mPOS1  	= NULL;
		_mPOS2  	= NULL;
	}
	~CaRmsd() {
//		for (int i = 0; i < _mLen; ++i) {
//			delete [] _mPOS1[i];
//			delete [] _mPOS2[i];
//		}
//		delete [] _mPOS1;
//		delete [] _mPOS1;
	}

	/* Initialize the temporary structure for caRMSD calculation. */
	void init(int len) {
		_mLen  = len;
		_mPOS1 = new double* [_mLen];
		_mPOS2 = new double* [_mLen];
		for (int i = 0; i < _mLen; ++i) {
			_mPOS1[i] = new double[3];
			_mPOS2[i] = new double[3];
		}
	}

	/* return true if the temporary structure is already initialized */
	bool isInitialized() {
		return (_mPOS1 != NULL);
	}

	// WARNING: this function is not thread safe, not good for OpenMP
	float ca_rmsd(float* coor1, float* coor2) {

	  if (coor1 == coor2) {
		return 0.0;
	  }

	  double rmsd;
	  int k3;

	  if (coor1 == _previous) {
		for (int k = 0; k < _mLen; ++k) {
		  k3 = k*3;
		  _mPOS2[k][0] = coor2[k3];
		  _mPOS2[k][1] = coor2[k3 + 1];
		  _mPOS2[k][2] = coor2[k3 + 2];
		}
	  } else {
		for (int k = 0; k < _mLen; ++k) {
		  k3 = k*3;
		  _mPOS1[k][0] = coor1[k3];
		  _mPOS1[k][1] = coor1[k3 + 1];
		  _mPOS1[k][2] = coor1[k3 + 2];
		  _mPOS2[k][0] = coor2[k3];
		  _mPOS2[k][1] = coor2[k3 + 1];
		  _mPOS2[k][2] = coor2[k3 + 2];
		}
	  }
	  fast_rmsd(_mPOS1, _mPOS2, _mLen, &rmsd);
	  _previous = coor1;

	  return (float)rmsd;
	}
};

/* Store a protein structures for RMSD calculation.
 */
class RmsdObj
{
	/* The file name of a PDB file */
	string fileName;

	/* The loaded PDB structure */
	SimPDB * pf;

	/* Some working space */
	static CaRmsd sp;
public:
	RmsdObj() {
		pf = NULL;
	}
	RmsdObj(const RmsdObj & obj) {
		copyConstruct(obj);
	}

	~RmsdObj() {
		delete pf;
	}

	void copyConstruct(const RmsdObj & obj) {
		fileName = obj.fileName;
		pf = obj.pf;
	}

	RmsdObj & operator=(const RmsdObj & obj) {
		copyConstruct(obj);
		return *this;
	}

	int operator==(const RmsdObj & obj) {
		if(fileName == obj.fileName) return 1;
		else return 0;
	}

	string getFileName() const {
		return fileName;
	}

	void print(ostream & os) const {
		os << "fileName " << fileName << endl;
	}

	/* Read in a data string */
	const void readin(string & data) {
		fileName = data;
	}

	/* Rarse a data file to read in the structure */
	void loadData()
	{
		pf = new SimPDB(fileName.c_str(), false);
	}

	/* Compute the distance between two PDB structures */
	double distance(RmsdObj & b) {
		if ( (*this) == b) return 0;
		else {

			if(pf == NULL) {
				loadData();
			}
			if(b.pf == NULL) {
				b.loadData();
			}

			// Check whether the temporary space is initialized or not.
			if (! sp.isInitialized()) sp.init(pf->mNumResidue);

			double val = sp.ca_rmsd(pf->mCAlpha, b.pf->mCAlpha);
			if (isnan(val)) return 0;
			else return val;
		}
	}

};

#endif /* RMSDOBJ_H_ */
