#ifndef TOPK_H_
#define TOPK_H_

#include <map>
#include <deque>
#include <set>

#include "assert.h"

#include "const.h"
#include "str_double_pair.h"

using namespace std;

class TopKList {//keeping the top k smallest items
    int k;
    /* sorting the item with the smallest priority on the top */
    //leda::p_queue<float, string> topK;
    map <string, float> topK;
    float curMaxPriority;//current minimal priority in the queue
	map <string, float> ::iterator curMaxIt;
    
public:
    
    TopKList(int kVal) {
		k = kVal;
		reset();
    }
    
    /* reset the whole object, except for k */
    void reset() {
		topK.clear();
		curMaxPriority = DIST_INFTY;//Dist::maxDist;//maximalBound;
		curMaxIt = topK.end();
    }
    
    int size() const {
		return topK.size();
    }
    
    bool isFull() const {
		if((int)topK.size() == k) return true;
		else return false;
    }

    /* return the ID with the minimal value, and delete it.
	Note: after calling this function, curMaxPriority, 
	curMaxIt are no longer valid.
	*/
    string delMin() {
		float min = DIST_INFTY;
		string minId = "";
		map <string, float> ::iterator minIt;
		map <string, float> ::iterator it;
		for(it = topK.begin(); it != topK.end(); it ++) {
			if(it->second < min) {
				min = it->second;
				minIt = it;
			}
		}
		minId = minIt->first;
		topK.erase(minIt);
		return minId;
    }
    
    /* return the top k list in resList */
    void getTopK(set <string> & resList) {
		map <string, float> ::iterator it;
		for(it = topK.begin(); it != topK.end(); it ++) {
			resList.insert(it->first);
		}
    }

    /* return the top k list in resList */
    void getTopK(deque <string> & resList) {
		map <string, float> ::iterator it;
		for(it = topK.begin(); it != topK.end(); it ++) {
			resList.push_back(it->first);
		}
    }
    
    float getCurMaxPriority() const {
		return curMaxPriority;
    }
    
    /* id: the id
     * p: the priority
     */
    void insert(string id, float p) {
		//if(p < curMaxPriority) {//insert the item into the list
		if((int)topK.size() < k) {
			topK[id] = p;

			if((int)topK.size() == k) {
				updateCurMaxPriority();
			}
		}else if(p < curMaxPriority) {//insert the item into the list
			topK[id] = p;
			if((int)topK.size() > k) {
				//curMaxPriority = delMax();
				delMax();
			}else { //topK.size() == k
				updateCurMaxPriority();
			}
		}
    }

	/* update curMaxPriority */
	void updateCurMaxPriority() {
		float max = - DIST_INFTY;
		map <string, float> ::iterator it;
		for(it = topK.begin(); it != topK.end(); it ++) {
			if(it->second > max) {
				max = it->second;
				curMaxIt = it;
			}
		}
		curMaxPriority = max;
	}
    
    /* delete the object with the maximal vaule in topK and update curMaxPriority and curMaxIt*/
    void delMax() {
		assert(topK.size() > 0);
		float max;//- DIST_INFTY;//Dist::maxDist;
		map <string, float> ::iterator maxIt;
		if(curMaxIt != topK.end()) {
			max = curMaxPriority;
			maxIt = curMaxIt;
		}else {
			max = - DIST_INFTY;
			maxIt = topK.end();
		}
		float preMax = max;
		map <string,  float> ::iterator preMaxIt = maxIt;
		map <string, float> ::iterator it;
		for(it = topK.begin(); it != topK.end(); it ++) {
			if(it->second > max) {
				preMax = max;
				max = it->second;
				preMaxIt = maxIt;
				maxIt = it;
			}else if(it->second > preMax) {
				preMax = it->second;
				preMaxIt = it;
			}
		}

		if(preMaxIt != topK.end() && preMaxIt != maxIt) {
			topK.erase(maxIt);
			curMaxPriority = preMax;
			curMaxIt = preMaxIt;
		}else {//preMaxIt is to be deleted
			topK.erase(maxIt);
			//find the current maximal
			max = - DIST_INFTY;//Dist::maxDist;
			for(it = topK.begin(); it != topK.end(); it ++) {
				if(it->second > max) {
					max = it->second;
					maxIt = it;
				}
			}	
			curMaxPriority = max;
			curMaxIt = maxIt;
		}
    }
};

#endif /*TOPK_H_*/
